 ; Ŀ
 ;   GrpID - list, count, and highlight all groups in the drawing.         
 ;   Copyright 1999 by Rocket Software                                     
 ;   Why are there no gray highlighters for unimportant details?           
 ; 
 (DEFUN C:GRPID (/ grdict lenstr num count sub grentt subnum grsub)
 ; Ŀ
 ;   Grdict is the group dictionary - a list of all groups in the drawing  
 ;   and names: (various_stuff (3 . "Group_name") (350 . <Ename>)...)      
 ;   The last two sublists are repeated for each group.                    
 ; 
  (setq grdict (dictsearch (namedobjdict) "acad_group"))
  (setq lenstr (strcat "/" (itoa (length grdict))))
  (setq num 0)
  (setq count 0)
 ; Ŀ
 ;   Step through the dictionary list looking for group names and enames.  
 ; 
  (while (setq sub (nth num grdict))
         (grtext -2 (strcat (itoa (setq num (1+ num))) lenstr))
 ; Ŀ
 ;   If the sublist is a name, print it and increment the counter.         
 ; 
         (cond ((= (car sub) 3)
                (prompt (cdr sub))
                (setq count (1+ count)))
 ; Ŀ
 ;   If the sublist is an ename (350), get the entity (group) list, which  
 ;   contains the ename for each entity in the group as a 340 list.        
 ;   So highlight it.                                                      
 ; 
               ((= (car sub) 350)
                (setq grentt (entget (cdr sub)))
                (if (null (assoc 340 grentt))
                    (prompt "\t*No Members.*\n")
                    (prompt "\n"))
                (setq subnum 0)
                (while (setq grsub (nth subnum grentt))
                       (setq subnum (1+ subnum))
                       (if (= (car grsub) 340)
                           (redraw (cdr grsub) 3))))))
  (write-line (strcat "\nGroups: " (itoa count)))
 (princ))